Error =

TargetStage = ${STAGE}

ifeq "${TargetStage}" ""
	TargetStage = ${stage}
endif

ifeq "${TargetStage}" ""
	TargetStage = debug
endif

ifneq "${TargetStage}" "debug"
	ifneq "${TargetStage}" "release"
		Error += Invalid target stage "${TargetStage}"
	endif
endif

ifeq "${TargetStage}" "debug"
	ToolSuffix = Debug
	LibSuffix  = StaticDebug
endif

ifeq "${TargetStage}" "release"
	LibSuffix = StaticRelease
endif

SourceRoot = ../../source
TargetRoot = ../../bin/unix
TempRoot   = ./temp/${TargetStage}

XMPRoot    = ../XMPToolkit

LibXMP = ${XMPRoot}/public/libraries/i80386linux/${TargetStage}/libXMPCore${LibSuffix}.a

################################################################################################

CC  = gcc
CPP = gcc -x c++
LD  = gcc

CPPFlags =  -fexceptions -funsigned-char -fPIC -Wno-multichar -Wno-implicit -Wno-ctor-dtor-privacy
CPPFlags += -DUNIX_ENV=1 -D_FILE_OFFSET_BITS=64 -D__LITTLE_ENDIAN__=1

LDFlags = 
LDLibs  =  ${LibXMP} -Xlinker -R -Xlinker .
LDLibs  += -lc -lm -lpthread -lstdc++ -lgcc_eh

ifeq "${TargetStage}" "debug"
	CPPFlags += -g -O0 -DDEBUG=1 -D_DEBUG=1
endif
ifeq "${TargetStage}" "release"
	CPPFlags += -O2 -Os -DNDEBUG=1
endif

################################################################################################

vpath %.cpp \
	${SourceRoot}: \
	${SourceRoot}/support:
	
Includes = \
	-I${SourceRoot}/support \
	-I${XMPRoot}/public/include

DumpImageObj = \
	${TempRoot}/DumpImage.o \
	${TempRoot}/MD5.o

TweakImageObj = \
	${TempRoot}/TweakImage.o \
	${TempRoot}/IPTC_Support.o \
	${TempRoot}/MD5.o \
	${TempRoot}/PSIR_FileWriter.o \
	${TempRoot}/Reconcile_Impl.o \
	${TempRoot}/TIFF_FileWriter.o \
	${TempRoot}/TIFF_Support.o \
	${TempRoot}/UnicodeConversions.o
	
################################################################################################

${TempRoot}/%.o : %.cpp
	@echo ""
	@echo "Compiling $<"
	${CPP} ${CPPFlags} ${Includes} -c $< -o $@

${TargetRoot}/DumpImage${ToolSuffix} : ${DumpImageObj}
	@echo ""
	@echo "Linking $@"
	${LD} ${LDFlags} ${DumpImageObj} ${LDLibs} -o $@

${TargetRoot}/TweakImage${ToolSuffix} : ${TweakImageObj}
	@echo ""
	@echo "Linking $@"
	${LD} ${LDFlags} ${TweakImageObj} ${LDLibs} -o $@

################################################################################################

DumpImage : msg create_dirs ${TargetRoot}/DumpImage${ToolSuffix}
	@echo "Done"

TweakImage : msg create_dirs ${TargetRoot}/TweakImage${ToolSuffix}
	@echo "Done"

msg :
	@echo ""
	@echo "Building MWG DumpImage tool (${TargetStage})"
ifneq "${Error}" ""
	@echo ""
	@echo "Error: ${Error}"
	@echo ""
	@echo "# To build one of the MWG tools:"
	@echo "#   make -f MWG_Tools.mak [DumpImage | TweakImage] [stage=<stage>]"
	@echo "# where"
	@echo "#   stage = debug | release"
	@echo "#"
	exit 1
endif

create_dirs :
	mkdir -p ${TempRoot}
	mkdir -p ${TargetRoot}

clean :
	rm -rf ${TempRoot}/*
	rm -rf ${TargetRoot}/*
